---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：91-Segment Config

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の記述**：根拠不足（定量的な数値がソースコードからは確認不可）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/segment-config/app/app-segment-config.ts` - AppSegmentConfigSchemaおよびparseAppSegmentConfig関数
- E-02: `packages/next/src/build/segment-config/pages/pages-segment-config.ts` - PagesSegmentConfigSchemaおよびparsePagesSegmentConfig関数
- E-03: `packages/next/src/build/segment-config/middleware/middleware-config.ts` - MiddlewareConfigInputSchemaおよび関連型定義
- E-04: `packages/next/src/build/segment-config/app/app-segments.ts` - collectSegments、collectAppPageSegments、collectAppRouteSegments、attach関数
- E-05: `packages/next/src/build/segment-config/app/collect-root-param-keys.ts` - collectRootParamKeys関数
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.91 Segment Configの説明

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | revalidateはnon-negative integerまたはfalse | E-01 (96-98行目) | ○ |
| C-02 | dynamicは4つの列挙値を持つ | E-01 (108-110行目) | ○ |
| C-03 | fetchCacheは7つの列挙値を持つ | E-01 (115-125行目) | ○ |
| C-04 | runtimeはedge/nodejsの2択 | E-01 (140行目) | ○ |
| C-05 | maxDurationは非負整数 | E-01 (145行目) | ○ |
| C-06 | Client Componentからの設定は無視される | E-04 (99-102行目) | ○ |
| C-07 | Edge Runtime + generateStaticParamsは禁止 | E-04 (49-53行目) | ○ |
| C-08 | BFSでローダーツリーを走査する | E-04 (78-123行目) | ○ |
| C-09 | 重複セグメントは排除される | E-04 (107-117行目) | ○ |
| C-10 | Pages RouterはexperimentalEdgeもサポート | E-02 (11行目) | ○ |
| C-11 | Middlewareのsourceは/始まりで4096文字以下 | E-03 (33-54行目) | ○ |
| C-12 | Zodバリデーションエラー時にドキュメントURLが含まれる | E-01 (183-188行目) | ○ |
| C-13 | collectSegmentsがAppRouteとAppPageで分岐する | E-04 (175-189行目) | ○ |
| C-14 | collectRootParamKeysが最初のlayoutまでの動的パラメータを収集 | E-05 (10-39行目) | ○ |
| C-15 | Middlewareのunstable_allowDynamicはglobパターン | E-03 (81-90行目, 110行目) | ○ |
| C-16 | unstable_prefetchはdiscriminatedUnion | E-01 (41-44行目) | ○ |
| C-17 | preferredRegionは文字列または配列 | E-01 (135行目) | ○ |
| C-18 | パフォーマンスは数十〜数百セグメントで問題なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（C-18）は定量的なベンチマークデータがなく、一般的な推論に基づく記述
  - 候補：ベンチマーク実施 / 大規模プロジェクトでの実測データ / Vercelのパフォーマンス報告

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い
- 0: 低リスク - Zodスキーマの定義は直接確認可能であり、誤りの余地が少ない

## 6) レビュアーチェックリスト（最小）
- [ ] AppSegmentConfigSchemaの全フィールドが網羅されているか
- [ ] PagesSegmentConfigSchemaとの差異が正しく記述されているか
- [ ] Middleware設定のmatcherの複雑な型（string | Array<string | object>）が正確か
- [ ] unstable_prefetchの2つのモード（static/runtime）の説明が十分か
